( function( $ ) {
    'use strict';

    /* rtl check */
	function rtl_owl(){
	if ($('body').hasClass("rtl")) {
		return true;
	} else {
		return false;
	}};

	/* Check rtl isotop*/
    function rtl_isotop() {
        if ( $( 'body' ).hasClass( 'rtl' ) ) {
           return false;
        } else {
           return true;
        }
    };

	/* OT Custom Nav Arrow Slider */
    var otNavText = [
        '<svg viewBox="0 0 103 16" xmlns="http://www.w3.org/2000/svg"><path d="M102.707 8.70711C103.098 8.31658 103.098 7.68342 102.707 7.29289L96.3431 0.928932C95.9526 0.538408 95.3195 0.538408 94.9289 0.928932C94.5384 1.31946 94.5384 1.95262 94.9289 2.34315L100.586 8L94.9289 13.6569C94.5384 14.0474 94.5384 14.6805 94.9289 15.0711C95.3195 15.4616 95.9526 15.4616 96.3431 15.0711L102.707 8.70711ZM0 9H102V7H0L0 9Z"/></svg>',
        '<svg viewBox="0 0 103 16" xmlns="http://www.w3.org/2000/svg"><path d="M102.707 8.70711C103.098 8.31658 103.098 7.68342 102.707 7.29289L96.3431 0.928932C95.9526 0.538408 95.3195 0.538408 94.9289 0.928932C94.5384 1.31946 94.5384 1.95262 94.9289 2.34315L100.586 8L94.9289 13.6569C94.5384 14.0474 94.5384 14.6805 94.9289 15.0711C95.3195 15.4616 95.9526 15.4616 96.3431 15.0711L102.707 8.70711ZM0 9H102V7H0L0 9Z"/></svg>'
    ];

	/* --------------------------------------------------
    * preloader
    * --------------------------------------------------*/
	if ( $('#royal_preloader').length ) {
		var $selector       = $('#royal_preloader'),
			$width          = $selector.data('width'),
			$height         = $selector.data('height'),
			$color          = $selector.data('color'),
			$bgcolor        = $selector.data('bgcolor'),
			$logourl        = $selector.data('url');
		
		Royal_Preloader.config({
			mode           : 'logo',
			logo           : $logourl,
			logo_size      : [$width, $height],
			showProgress   : true,
			showPercentage : true,
			text_colour: $color,
			background:  $bgcolor,
		});        
	};

	$(document).ready( function() {
		
		/* --------------------------------------------------
	    * mobile menu
	    * --------------------------------------------------*/
	    $('.mmenu_wrapper li:has(ul)').prepend('<span class="arrow"><i class="ot-flaticon-arrow-point-to-right"></i></span>');
	    $(".mmenu_wrapper .mobile_mainmenu > li span.arrow").on('click',function() {
	        $(this).parent().find("> ul").stop(true, true).slideToggle()
	        $(this).toggleClass( "active" ); 
	    });
		
		$( "#mmenu_toggle" ).on('click', function() {
			$(this).toggleClass( "active" );
			$(this).parents('.header_mobile').toggleClass( "open" );
			if ($(this).hasClass( "active" )) {
				$('.mobile_nav').stop(true, true).slideDown(300);
			}else{
				$('.mobile_nav').stop(true, true).slideUp(300);
			}
		});

		/* --------------------------------------------------
	    * sticky header
	    * --------------------------------------------------*/
		$('.header-static .is-fixed').parent().append('<div class="header-clone"></div>');
		$('.header-clone').height($('#site-header .is-fixed').outerHeight());
		$('.header-static .header-clone').hide();	
		$(window).on("scroll", function(){
			var site_header = $('#site-header').outerHeight() + 1;	
				
			if ($(window).scrollTop() >= site_header) {	    	
				$('.site-header .is-fixed').addClass('is-stuck');	
				$('.header-static .header-clone').show();	
			}else {
				$('.site-header .is-fixed').removeClass('is-stuck');		              
				$('.header-static .header-clone').hide();
			}
		});
	        
	    /* --------------------------------------------------
	    * gallery post
	    * --------------------------------------------------*/
	    var galleryPost = $('.gallery-post');
		if (galleryPost.length > 0 ) {
			galleryPost.each( function () {
				var selector = $(this).find('.owl-carousel');
				selector.owlCarousel({
					rtl: rtl_owl(),
					autoplay:true,
					autoplayTimeout: 6000,
					loop:true,
					margin:0,
					responsiveClass:true,
					dotsClass: 'owl-dots ot-dots-classic',
					dots:true,
					nav:true,
                	navText: otNavText,
					responsive : {
	                    0 : {
	                        items: 1,
	                    },
	                    768 : {
	                        items: 1,
	                    },
	                    1024 : {
	                        items: 1,
	                    }
	                }
				});
			});
		}
		/* --------------------------------------------------
	    * related projects
	    * --------------------------------------------------*/
	    $('.portfolio-related-posts').each( function () {
	        var selector = $(this);
	        selector.find('.owl-carousel').owlCarousel({
	            rtl: rtl_owl(),
	            autoplay: true,
	            loop: false,
	            dotsClass: 'owl-dots ot-dots-classic',
	            dots: false,
	            nav: false,
	            responsive : {
	                0 : {
	                    items: 1,
	                    margin: 0,
	                },
	                768 : {
	                    items: 2,
	                    margin: 30,
	                },
	                1024 : {
	                    items: 3,
	                    margin: 30,
	                }
	            }
	        });
	    });
	});


	$(window).on('load', function () {

		/* --------------------------------------------------
	    * popup video
	    * --------------------------------------------------*/
	  	var video_popup = $('.video-popup');
	   	if (video_popup.length > 0 ) {
		   	video_popup.each( function(){
		   		var selector    = $(this),
	                videoPopup  = selector.find('.btn-play');
			   	selector.lightGallery({
				   selector: videoPopup,
			   	});
		   	});
	   	};
	   	
	});

    /* --------------------------------------------------
    * back to top
    * --------------------------------------------------*/
    if ($('#back-to-top').length) {
	    var scrollTrigger = 500, /* px*/
	        backToTop = function () {
	            var scrollTop = $(window).scrollTop();
	            if (scrollTop > scrollTrigger) {
	                $('#back-to-top').addClass('show');
	            } else {
	                $('#back-to-top').removeClass('show');
	            }
	        };
	    backToTop();
	    $(window).on('scroll', function () {
	        backToTop();
	    });
	    $('#back-to-top').on('click', function (e) {
	        e.preventDefault();
	        $('html,body').animate({
	            scrollTop: 0
	        }, 700);
	    });	
	}

} )( jQuery );
