<?php
if ( ! function_exists( 'ronmi_page_header' ) ) {
    function ronmi_page_header (){
        $pheader = '';
        if ( function_exists('rwmb_meta') ) {
            $pheader = rwmb_meta('pheader_switch');
            if( is_home() || is_archive() || is_search() || is_singular('post') || is_404() ){
                $pheader = rwmb_meta('pheader_switch', "type=switch", get_option( 'page_for_posts' ));
                if( empty($pheader) && !empty(ronmi_get_option('pheader_switch')) ){
                    $pheader = '1';
                }
            }
            if( class_exists( 'woocommerce' ) ){
                if( is_shop() || is_product_category() || is_product_tag() || is_product() ){
                    $pheader = rwmb_meta('pheader_switch', "type=switch", get_option( 'woocommerce_shop_page_id' ));
                }
            }
            if( !$pheader ){
                return;
            }
        }
        if( !ronmi_get_option('pheader_switch') && !$pheader ) {
            return;
        }else{
            $bg     = '';
            $title  = '';
            $output = array();

            if ( is_home() ) {
                $title = get_the_title(get_option('page_for_posts'));
            } elseif ( is_404() ) {
                $title = esc_html__('Page not found', 'ronmi');
            } elseif ( is_search() ) {
                $title = esc_html__('Search Results for: ', 'ronmi') . get_search_query();
            } elseif ( is_archive() ) {
                $title = get_the_archive_title();
            } elseif ( is_singular('post') ) {
                $title = ronmi_get_option( 'ptitle_post' ) ? ronmi_get_option( 'ptitle_post' ) : get_the_title();
            }else {
                $title = get_the_title();
            }
            
            if (!function_exists('rwmb_meta')) {
                $bg = ronmi_get_option( 'pheader_img' );
            } else {
                if( is_home() ) {
                    $images = rwmb_meta('pheader_bg_image', "type=image", get_option( 'page_for_posts' ));
                }elseif( class_exists( 'woocommerce' ) ){
                    if( is_shop() || is_product_category() || is_product_tag() || is_product() ){
                        $images = rwmb_meta('pheader_bg_image', "type=image", get_option( 'woocommerce_shop_page_id' ));
                    }else{
                        $images = rwmb_meta('pheader_bg_image', "type=image");
                    }
                }else{
                    $images = rwmb_meta('pheader_bg_image', "type=image");
                }
                if (!$images) {
                    $bg = ronmi_get_option( 'pheader_img' );
                } else {
                    foreach ($images as $image) {
                        $bg = $image['full_url'];
                        break;
                    }
                }
            }

            if ($title) {
                $output[] = sprintf('%s', $title);
            }
        ?>        
            <div class="page-header dtable <?php echo esc_attr( ronmi_get_option( 'pheader_align' ) ); ?>" <?php if ($bg) { ?> style="background-image: url(<?php echo esc_url($bg); ?>);" <?php } ?>>
                <div class="dcell">
                    <div class="container">
                        <div class="page-header-content">
                            
                            <?php if( is_singular('post') ){ ?>
                                <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                                <div class="post-box">
                                    <div class="entry-media">
                                        <?php ronmi_posted_in(); ?>
                                        <?php if ( 'post' === get_post_type() ) : if ( ronmi_get_option( 'post_entry_meta' ) ) ?>
                                        <div class="entry-meta">
                                            <?php ronmi_post_meta(); ?>
                                        </div><!-- .entry-meta -->
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php endwhile; endif; // End of the loop. ?>
                            <?php } ?>

                            <?php if( class_exists( 'woocommerce' ) && is_woocommerce() ) { ?>
                                <?php if( !is_product() ){ ?>
                                    <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
                                        <h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
                                    <?php endif; ?>                            
                                <?php }else{ ?>
                                    <h1 class="page-title"><?php the_title(); ?></h1>
                                <?php } ?>    
                                <?php do_action( 'ronmi_woocommerce_breadcrumb' ); ?>
                            <?php }else{ ?>
                                <h1 class="page-title"><?php echo implode('', $output); ?></h1>
                            <?php 
                                if (function_exists('ronmi_breadcrumbs') && ronmi_get_option('breadcrumbs')):
                                    echo ronmi_breadcrumbs();
                                endif;
                            } ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        }
    }
}