<?php
/**
 * Template part for displaying single post content
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Ronmi
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('blog-post post-box'); ?>>
    
    <div class="inner-post">
        <?php if( ronmi_get_option( 'ptitle_post' ) ){ ?>

        <header class="entry-header">
            <?php the_title( '<h3 class="entry-title">', '</h3>' ); ?>
        </header><!-- .entry-header -->

        <?php } ?>

        <div class="entry-summary">

            <?php

                the_content(sprintf(
                    wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                        __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'ronmi'),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    get_the_title()
                ));

                wp_link_pages(array(
                    'before' => '<div class="page-links">' . esc_html__('Pages:', 'ronmi'),
                    'after' => '</div>',
                ));
            ?>

        </div><!-- .entry-content -->
        <div class="entry-footer clearfix">
            <?php ronmi_entry_footer(); ?>
            <?php if( ronmi_get_option('post_socials') ) ronmi_socials_share(); ?>
        </div>
        <?php if( ronmi_get_option('author_box') ) ronmi_author_info_box(); ?>
        
    </div>
</article>
<?php if( ronmi_get_option('post_nav') ) ronmi_single_post_nav(); ?>
<?php if( ronmi_get_option('related_post') ) ronmi_related_posts(); ?>
