<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Pricing Table
 */
class Ronmi_Pricing_Table extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'ot-pricing-table';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'OT Pricing Table', 'ronmi' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-price-table';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_ronmi' ];
	}

	protected function register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Title & Price', 'ronmi' ),
			]
		);

		$this->add_control(
			'icon_type',
			[
				'label' => __( 'Icon Type', 'ronmi' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'font',
				'options' => [
					'font' 	=> __( 'Font Icon', 'ronmi' ),
					'image' => __( 'Image Icon', 'ronmi' ),
				]
			]
		);

		$this->add_control(
	       'icon_image',
	        [
	            'label' => esc_html__( 'Image', 'ronmi' ),
	            'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
			  	],
			  	'condition' => [
					'icon_type' => 'image',
				]
		    ]
	    );

		$this->add_control(
			'icon_font',
			[
				'label' => __( 'Icon', 'ronmi' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'icon_type' => 'font',
				]
			]
		);

		$this->add_control(
			'icon_view',
			[
				'label' => __( 'View Icon', 'ronmi' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'default' => __( 'Default', 'ronmi' ),
					'stacked' => __( 'Stacked', 'ronmi' ),
				],
				'default' => 'default',
				'prefix_class' => 'ot-view-',
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'ronmi' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Digital', 'ronmi' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'heading_tag',
			[
				'label' => __( 'Title HTML Tag', 'ronmi' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h2' => 'H2',
					'h3' => 'H3',
					'h4' => 'H4',
					'h5' => 'H5',
					'h6' => 'H6',
				],
				'default' => 'h5',
				'condition'	=> [
					'title!'	=> ''
				]
			]
		);

		$this->add_control(
			'sub_heading',
			[
				'label' => __( 'Description', 'ronmi' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'The easy, safe way to manage online spending at work', 'ronmi' ),
			]
		);

		$this->add_control(
			'price',
			[
				'label' => __( 'Price', 'ronmi' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '$15', 'ronmi' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_features',
			[
				'label' => __( 'Features', 'ronmi' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'item_features_text',
			[
				'label' => __( 'Text', 'ronmi' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'List Item', 'ronmi' ),
			]
		);

		$default_icon = [
			'value' => 'fas fa-check',
			'library' => 'fa-solid',
		];

		$repeater->add_control(
			'selected_item_icon',
			[
				'label' => __( 'Icon', 'ronmi' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'item_icon',
				'default' => $default_icon,
			]
		);

		$repeater->add_control(
			'item_icon_color',
			[
				'label' => __( 'Icon Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} i' => 'color: {{VALUE}}',
					'{{WRAPPER}} {{CURRENT_ITEM}} svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'features_list',
			[
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'item_features_text' => __( 'List Item #1', 'ronmi' ),
						'selected_item_icon' => $default_icon,
					],
					[
						'item_features_text' => __( 'List Item #2', 'ronmi' ),
						'selected_item_icon' => $default_icon,
					],
					[
						'item_features_text' => __( 'List Item #3', 'ronmi' ),
						'selected_item_icon' => $default_icon,
					],
				],
				'title_field' => '{{{ item_features_text }}}',
				'prevent_empty' => false
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_footer',
			[
				'label' => __( 'Button', 'ronmi' ),
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => __( 'Button Text', 'ronmi' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Click Here', 'ronmi' ),
			]
		);

		$this->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'ronmi' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'ronmi' ),
				'default' => [
					'url' => '#',
				],
			]
		);

		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'style_table_section',
			[
				'label' => __( 'Table Box', 'ronmi' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'box_padding',
			[
				'label' => __( 'Padding Box', 'ronmi' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'style_content_section',
			[
				'label' => __( 'Content', 'ronmi' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		//Icon
		$this->add_control(
			'heading_icon',
			[
				'label' => __( 'Icon', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'conditions'	=>[
					'relation' => 'or',
					'terms' => [
				        [
				            'name' => 'icon_font[value]',
				            'operator' => '!=',
				            'value' => ''
				        ],
				        [
				            'name' => 'icon_image[url]',
				            'operator' => '!=',
				            'value' => ''
				        ]
				    ]
				]
			]
		);
		$this->add_control(
			'icon_padding',
			[
				'label' => __( 'Padding', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__icon' => 'padding: {{SIZE}}{{UNIT}};',
				],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'conditions'	=>[
					'relation' => 'or',
					'terms' => [
						[
							'relation' => 'and',
							'terms' => [
								[
						            'name' => 'icon_type',
						            'operator' => '==',
						            'value' => 'font'
						        ],
						        [
						            'name' => 'icon_font[value]',
						            'operator' => '!=',
						            'value' => ''
						        ],
						        [
						            'name' => 'icon_view',
						            'operator' => '==',
						            'value' => 'stacked'
						        ],
							]
						],
						[
							'relation' => 'and',
							'terms' => [
								[
						            'name' => 'icon_type',
						            'operator' => '==',
						            'value' => 'image'
						        ],
								[
						            'name' => 'icon_image[url]',
						            'operator' => '!=',
						            'value' => ''
						        ],
						        [
						            'name' => 'icon_view',
						            'operator' => '==',
						            'value' => 'stacked'
						        ],
							]
						]
				    ]
				]
			]
		);
		$this->add_responsive_control(
			'icon_space',
			[
				'label' => __( 'Spacing', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'conditions'	=>[
					'relation' => 'or',
					'terms' => [
				        [
				            'name' => 'icon_font[value]',
				            'operator' => '!=',
				            'value' => ''
				        ],
				        [
				            'name' => 'icon_image[url]',
				            'operator' => '!=',
				            'value' => ''
				        ]
				    ]
				]
			]
		);
		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Size', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'conditions'	=>[
					'relation' => 'or',
					'terms' => [
				        [
				            'name' => 'icon_font[value]',
				            'operator' => '!=',
				            'value' => ''
				        ],
				        [
				            'name' => 'icon_image[url]',
				            'operator' => '!=',
				            'value' => ''
				        ]
				    ]
				]
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ot-pricing-table__icon svg' => 'fill: {{VALUE}};'
				],
				'condition'	=>[
					'icon_font[value]!'	=> '',
					'icon_type' => 'font'
				],
			]
		);

		$this->add_control(
			'icon_bgcolor',
			[
				'label' => __( 'Background', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__icon' => 'background-color: {{VALUE}};',
				],
				'conditions'	=>[
					'relation' => 'or',
					'terms' => [
						[
							'relation' => 'and',
							'terms' => [
								[
						            'name' => 'icon_type',
						            'operator' => '==',
						            'value' => 'font'
						        ],
								[
						            'name' => 'icon_font[value]',
						            'operator' => '!=',
						            'value' => ''
						        ],
						        [
						            'name' => 'icon_view',
						            'operator' => '==',
						            'value' => 'stacked'
						        ],
							]
						],
						[
							'relation' => 'and',
							'terms' => [
								[
						            'name' => 'icon_type',
						            'operator' => '==',
						            'value' => 'image'
						        ],
								[
						            'name' => 'icon_image[url]',
						            'operator' => '!=',
						            'value' => ''
						        ],
						        [
						            'name' => 'icon_view',
						            'operator' => '==',
						            'value' => 'stacked'
						        ],
							]
						]
				    ]
				]
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label' => __( 'Border Radius', 'ronmi' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'conditions'	=>[
					'relation' => 'or',
					'terms' => [
						[
							'relation' => 'and',
							'terms' => [
								[
						            'name' => 'icon_type',
						            'operator' => '==',
						            'value' => 'font'
						        ],
								[
						            'name' => 'icon_font[value]',
						            'operator' => '!=',
						            'value' => ''
						        ],
						        [
						            'name' => 'icon_view',
						            'operator' => '==',
						            'value' => 'stacked'
						        ],
							]
						],
						[
							'relation' => 'and',
							'terms' => [
								[
						            'name' => 'icon_type',
						            'operator' => '==',
						            'value' => 'image'
						        ],
								[
						            'name' => 'icon_image[url]',
						            'operator' => '!=',
						            'value' => ''
						        ],
						        [
						            'name' => 'icon_view',
						            'operator' => '==',
						            'value' => 'stacked'
						        ],
							]
						]
				    ]
				]
			]
		);

		//Title
		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'condition'	=>[
					'title!'	=> ''
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'title_space',
			[
				'label' => __( 'Spacing', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition'	=>[
					'title!'	=> ''
				]
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__title' => 'color: {{VALUE}};',
				],
				'condition'	=>[
					'title!'	=> ''
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .ot-pricing-table__title',
				'condition'	=>[
					'title!'	=> ''
				],
			]
		);

		//Desc
		$this->add_control(
			'heading_desc',
			[
				'label' => __( 'Description', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'condition'	=>[
					'sub_heading!'	=> ''
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'desc_space',
			[
				'label' => __( 'Spacing', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition'	=>[
					'sub_heading!'	=> ''
				]
			]
		);
		$this->add_control(
			'desc_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__subtitle' => 'color: {{VALUE}};',
				],
				'condition'	=>[
					'sub_heading!'	=> ''
				]
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'selector' => '{{WRAPPER}} .ot-pricing-table__subtitle',
				'condition'	=>[
					'sub_heading!'	=> ''
				],
			]
		);	

		//Price
		$this->add_control(
			'heading_price',
			[
				'label' => __( 'Price', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'price_space',
			[
				'label' => __( 'Spacing', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__price' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'price_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__price' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'selector' => '{{WRAPPER}} .ot-pricing-table__price',
				'separator' => 'after',
			]
		);
		$this->add_control(
			'is_divider',
			[
				'label'   => esc_html__( 'Divider', 'ronmi' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => '',
			]
		);
		$this->add_control(
			'divider_color',
			[
				'label' => __( 'Divider Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__divider span' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'is_divider' => 'yes',
				]
			]
		);
		$this->add_control(
			'divider_height',
			[
				'label' => __( 'Divider Height', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 1,
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 10,
						'step' => 0.1,
					],
				],
				'condition' => [
					'is_divider' => 'yes',
				],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__divider span' => 'height: {{SIZE}}{{UNIT}}',
				],
			]
		);

		//Features
		$this->add_control(
			'heading_des',
			[
				'label' => __( 'Features', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'features_spacing',
			[
				'label' => __( 'Spacing', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__features-list' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'features_icon_size',
			[
				'label' => __( 'Icon Size', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .pricing-features-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'features_icon_color',
			[
				'label' => __( 'Icon Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .pricing-features-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .pricing-features-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'features_color',
			[
				'label' => __( 'Text Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ot-pricing-table__features-list' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'features_typography',
				'selector' => '{{WRAPPER}} .pricing-features-items',
			]
		);

		$this->end_controls_section();

		//Button
		$this->start_controls_section(
			'btn_style_section',
			[
				'label' => __( 'Button', 'ronmi' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'btn_width',
			[
				'label' => __( 'Width', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .octf-btn' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'btn_padding',
			[
				'label' => 'Padding',
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .octf-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .octf-btn',
			]
		);
		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'ronmi' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => __( 'Text Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .octf-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_bg',
			[
				'label' => __( 'Background', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .octf-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} .octf-btn',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'ronmi' ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label' => __( 'Text Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .octf-btn:hover, {{WRAPPER}} .octf-btn:focus' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'btn_bg_hover_color',
			[
				'label' => __( 'Background', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .octf-btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'border_hover_color',
			[
				'label' => __( 'Border Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .octf-btn:hover, {{WRAPPER}} .octf-btn:focus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$heading_tag = $settings['heading_tag'];
		$this->add_render_attribute( 'title', 'class', 'ot-pricing-table__title' );
		$this->add_render_attribute( 'sub_heading', 'class', 'ot-pricing-table__subtitle' );

		if ( ! empty( $settings['btn_link']['url'] ) ) {
			$this->add_link_attributes( 'button_detail', $settings['btn_link'] );
		}
		$this->add_render_attribute( 'button_detail', 'class', 'octf-btn octf-btn-primary' );
		?>

		<div class="ot-pricing-table">
			<div class="ot-pricing-table__header">
				<?php if( !empty( $settings['icon_font']['value'] ) || !empty( $settings['icon_image']['url'] ) ) : ?>
					<div class="ot-pricing-table__icon"> 
						<?php if( $settings['icon_type'] == 'font' ){ 
					    	Icons_Manager::render_icon( $settings['icon_font'], [ 'aria-hidden' => 'true' ] );
				    	} elseif( $settings['icon_type'] == 'image' ){ 
					    	echo Group_Control_Image_Size::get_attachment_image_html(  $settings, 'thumbnail', 'icon_image'  );
				    	} ?>
					</div>
				<?php endif; ?>

				<?php if ( ! empty( $settings['title'] ) ) : ?>
					<<?php echo $heading_tag . ' ' . $this->get_render_attribute_string( 'title' ); ?>><?php echo $settings['title'] . '</' . $heading_tag; ?>>
				<?php endif; ?>
				<?php if ( ! empty( $settings['sub_heading'] ) ) : ?><span <?php echo $this->get_render_attribute_string( 'sub_heading' ); ?>><?php echo $settings['sub_heading']; ?></span>
				<?php endif; ?>
			</div>
			<div class="ot-pricing-table__price">
				<span class="ot-pricing-table__price-value"><?php echo $settings['price']; ?></span>
			</div>
			<?php if( $settings['is_divider'] ) { ?>
			<div class="ot-pricing-table__divider"><span></span></div>
			<?php } ?>
			<?php if( !empty($settings['features_list']) ){ ?>
			<div class="ot-pricing-table__features-list">
				<ul class="pricing-features-items">
					<?php foreach ( $settings['features_list'] as $item ) : ?>
					<li class="pricing-features-item">
						<span class="pricing-features-icon">
						<?php Icons_Manager::render_icon( $item['selected_item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
						</span>
						<span class="pricing-features-text"><?php echo $item['item_features_text']; ?></span>
					</li>
					<?php endforeach ?>
				</ul>
			</div>
			<?php } ?>
			<div class="ot-pricing-table__footer">
				<?php if( !empty($settings['button_text']) ){ ?><a <?php echo $this->get_render_attribute_string( 'button_detail' ); ?>><?php echo esc_html( $settings['button_text'] ); ?></a><?php } ?>
			</div>
		</div>

	    <?php
	}

	protected function content_template() {}
}
// After the Ronmi_Pricing_Table class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Ronmi_Pricing_Table() );