<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Hover Image
 */
class Ronmi_Hover_Image extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'ot-hover-image';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'OT Hover Image', 'ronmi' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-image';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_ronmi' ];
	}

	protected function register_controls() {

		/*Content Image*/
		$this->start_controls_section(
			'section_side_a_content',
			[
				'label' => __( 'Front Image', 'ronmi' ),
			]
		);

		$this->add_control(
			'image_front',
			[
				'label' => __( 'Choose Image', 'ronmi' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

		/*Icon*/
		$this->start_controls_section(
			'section_back_icon',
			[
				'label' => __( 'Back', 'ronmi' ),
			]
		);

		$this->add_control(
			'back_icon_type',
			[
				'label'       => __( 'Icon Type', 'ronmi' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'icon',
				'options'     => [
					'icon'      => __( 'Font Icon', 'ronmi' ),
					'image'     => __( 'Custom Image', 'ronmi' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'hover_image_back_icon',
			[
				'label'            => __( 'Icon', 'ronmi' ),
				'type'             => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default'          => [
					'value'   => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition'        => [
					'back_icon_type'   => 'icon',
				],
			]
		);

		$this->add_control(
			'hover_image_back_icon_image',
			[
				'label'       => __( 'Image', 'ronmi' ),
				'type'        => Controls_Manager::MEDIA,
				'default'     => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'   => [
					'back_icon_type'   => 'image',
				],
			]
		);
		
		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'ronmi' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'ronmi' ),
			]
		);

		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style Content', 'ronmi' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'background_overlay',
			[
				'label' => __( 'Background Overlay', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ot-hover-image .overlay' => 'background-color: {{VALUE}};',
				]
			]
		);
		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'ronmi' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .ot-hover-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		//Icon/Image
		$this->add_control(
			'heading_icon',
			[
				'label' => __( 'Icon/Image', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Size', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ot-hover-image .overlay i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .ot-hover-image .overlay svg' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .ot-hover-image .overlay img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ot-hover-image .overlay i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ot-hover-image .overlay svg' => 'fill: {{VALUE}};'
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( ! empty( $settings['link']['url'] ) ) {
			$this->add_link_attributes( 'link_box', $settings['link'] );
		}
		$this->add_render_attribute( 'link_box', 'class', 'ot-hover-image__link' );

		?>

		<div class="ot-hover-image">
			<?php if ( ! empty( $settings['link']['url'] ) ) { ?>
			<a <?php echo $this->get_render_attribute_string( 'link_box' ) ?>></a>
			<?php } ?>
			<figure class="ot-hover-image__inner">
				<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'image_front' ); ?>
				<span class="overlay flex-middle">
					<?php if( $settings['back_icon_type'] == 'icon' ){ 
				    	Icons_Manager::render_icon( $settings['hover_image_back_icon'], [ 'aria-hidden' => 'true' ] );
			    	} elseif( $settings['back_icon_type'] == 'image' ){ 
				    	echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'hover_image_back_icon_image' );
			    	} ?>
				</span>
			</figure>
	    </div>

	    <?php
	}

}
// After the Ronmi_Hover_Image class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Ronmi_Hover_Image() );